<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0">Edit Order #<?php echo e($order->code); ?></h4>
                    </div>

                    <div class="card-body">
                        <form action="<?php echo e(route('whole_sale_orders.update', $order->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <!-- ================= ORDER & SHIPPING INFO ================= -->
                            <div class="row">
                                <div class="col-md-6">
                                    <h5>Order Information</h5>

                                    <div class="mb-2">
                                        <label>Order Code</label>
                                        <input type="text" class="form-control" value="<?php echo e($order->code); ?>" disabled>
                                    </div>

                                    <div class="mb-2">
                                        <label>Delivery Status</label>
                                        <select name="delivery_status" class="form-control">
                                            <?php $__currentLoopData = ['pending','confirmed','on_delivery','delivered','cancelled']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($status); ?>" <?php echo e($order->delivery_status==$status?'selected':''); ?>>
                                                    <?php echo e(ucfirst(str_replace('_',' ',$status))); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="mb-2">
                                        <label>Payment Status</label>
                                        <select name="payment_status" class="form-control">
                                            <option value="unpaid" <?php echo e($order->payment_status=='unpaid'?'selected':''); ?>>Unpaid</option>
                                            <option value="paid"   <?php echo e($order->payment_status=='paid'?'selected':''); ?>>Paid</option>
                                        </select>
                                    </div>
                                </div>

                                <?php $shipping = json_decode($order->shipping_address, true); ?>
                                <div class="col-md-6">
                                    <h5>Shipping Information</h5>

                                    <div class="mb-2">
                                        <label>Name</label>
                                        <input type="text" name="shipping_name" class="form-control" value="<?php echo e($shipping['name'] ?? ''); ?>">
                                    </div>

                                    <div class="mb-2">
                                        <label>Phone</label>
                                        <input type="text" name="shipping_phone" class="form-control" value="<?php echo e($shipping['phone'] ?? ''); ?>">
                                    </div>

                                    <div class="mb-2">
                                        <label>Address</label>
                                        <textarea name="shipping_address" class="form-control"><?php echo e($shipping['address'] ?? ''); ?></textarea>
                                    </div>
                                </div>
                            </div>

                            <!-- ================= ADD PRODUCT ROW ================= -->
                            <div class="card border mt-3">
                                <div class="card-body py-3">
                                    <h6 class="mb-3">Add Product</h6>
                                    <div class="row g-2 align-items-end">
                                        <div class="col-md-4">
                                            <label class="form-label mb-1 small">Product</label>
                                            <select id="addProductSelect" class="form-control" style="width:100%">
                                                <option value="">-- Search product --</option>
                                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($product->id); ?>"
                                                            data-name="<?php echo e($product->name); ?>"
                                                            data-price="<?php echo e($product->unit_price); ?>"
                                                            data-wholesale="<?php echo e($product->whole_sale_price ?? $product->unit_price); ?>">
                                                        <?php echo e($product->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label mb-1 small">Qty</label>
                                            <input type="number" id="addQty" class="form-control" value="1" min="1">
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label mb-1 small">Unit Price</label>
                                            <input type="number" id="addPrice" class="form-control" readonly step="0.01" value="0">
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label mb-1 small">Whole Sale Price</label>
                                            <input type="number" id="addWholesale" class="form-control" step="0.01" value="0">
                                        </div>
                                        <div class="col-md-2">
                                            <button type="button" id="addProductBtn" class="btn btn-success w-100">
                                                + Add Row
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- ================= /ADD PRODUCT ROW ================= -->

                            <!-- ================= ORDER DETAILS ================= -->
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h5>Order Details</h5>

                                    <div class="table-responsive">
                                        <table class="table table-bordered" id="orderDetailsTable">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Product</th>
                                                <th width="90">Qty</th>
                                                <th width="120">Unit Price</th>
                                                <th width="120">Whole Sale Price</th>
                                                <th width="120">Total</th>
                                                <th width="70">Action</th>
                                            </tr>
                                            </thead>

                                            <tbody>
                                            <?php $__currentLoopData = $order->orderDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($key + 1); ?></td>

                                                    <td>
                                                        <?php echo e($detail->product->name ?? 'Product'); ?>

                                                        <input type="hidden" name="order_detail_ids[]" value="<?php echo e($detail->id); ?>">
                                                        <input type="hidden" name="product_ids[]"      value="<?php echo e($detail->product_id); ?>">
                                                    </td>

                                                    <td>
                                                        <input type="number"
                                                               name="quantities[]"
                                                               class="form-control form-control-sm quantity-input"
                                                               value="<?php echo e($detail->quantity); ?>" min="1">
                                                    </td>

                                                    <td>
                                                        <input type="number"
                                                               name="prices[]"
                                                               class="form-control  form-control-sm "
                                                               readonly
                                                               value="<?php echo e(($detail->whole_sale_prices ?? $detail->price)/ $detail->quantity); ?>"
                                                               step="0.01">
                                                    </td>

                                                    <td>
                                                        <input type="number"
                                                               name="whole_sale_prices[]"
                                                               class="form-control form-control-sm price-input"
                                                               value="<?php echo e(($detail->price) / $detail->quantity); ?>"
                                                               step="0.01">
                                                    </td>

                                                    <td>
                                                        <input type="text"
                                                               class="form-control form-control-sm row-total"
                                                               readonly>
                                                    </td>

                                                    <td>
                                                        <button type="button" class="btn btn-sm btn-danger remove-row">×</button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>

                                            <tfoot>
                                            <tr>
                                                <th colspan="5" class="text-end">Subtotal</th>
                                                <th colspan="2" id="subtotalDisplay">৳0.00</th>
                                            </tr>
                                            <tr>
                                                <th colspan="5" class="text-end">Shipping Charge</th>
                                                <th colspan="2">
                                                    <input type="number"
                                                           name="shipping_cost"
                                                           id="shippingCost"
                                                           class="form-control form-control-sm"
                                                           value="<?php echo e($order->shipping_cost); ?>"
                                                           step="0.01">
                                                </th>
                                            </tr>
                                            <tr>
                                                <th colspan="5" class="text-end">Coupon Discount</th>
                                                <th colspan="2">
                                                    <input type="number"
                                                           name="coupon_discount"
                                                           id="couponDiscount"
                                                           class="form-control form-control-sm"
                                                           value="<?php echo e($order->coupon_discount); ?>"
                                                           step="0.01">
                                                </th>
                                            </tr>
                                            <tr>
                                                <th colspan="5" class="text-end">Grand Total</th>
                                                <th colspan="2" id="grandTotalDisplay">৳0.00</th>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <!-- ================= /ORDER DETAILS ================= -->

                            <div class="mt-3">
                                <a href="#" class="btn btn-secondary">Cancel</a>
                                <button type="submit" class="btn btn-primary">Update Order</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ================= SELECT2 CSS ================= -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">

    <!-- ================= JAVASCRIPT ================= -->
    <script>
        /**
         * Safely initialise Select2 after both jQuery and Select2 JS are available.
         * This avoids "jQuery is not defined" and "$.fn.select2 is not a function"
         * errors that occur when script load order is not guaranteed.
         */
        function waitForJQueryAndSelect2(callback) {
            if (typeof jQuery === 'undefined') {
                setTimeout(function () { waitForJQueryAndSelect2(callback); }, 50);
                return;
            }

            if (typeof jQuery.fn.select2 !== 'undefined') {
                callback(jQuery);
                return;
            }

            // jQuery is ready but Select2 not yet — inject it dynamically
            var script = document.createElement('script');
            script.src = 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js';
            script.onload = function () { callback(jQuery); };
            document.head.appendChild(script);
        }

        waitForJQueryAndSelect2(function ($) {

            // ---- Select2 init ----
            $('#addProductSelect').select2({
                placeholder: '-- Search product --',
                allowClear: true,
                width: '100%'
            });

            // Auto-fill price fields when product is selected
            $('#addProductSelect').on('change', function () {
                var selected = this.options[this.selectedIndex];
                document.getElementById('addPrice').value     = selected.dataset.price     || 0;
                document.getElementById('addWholesale').value = selected.dataset.wholesale || 0;
            });

            // ---- Row total: qty × unit price ----
            function calculateRowTotal(row) {
                var qty   = parseFloat(row.querySelector('.quantity-input').value) || 0;
                var price = parseFloat(row.querySelector('.price-input').value)    || 0;
                row.querySelector('.row-total').value = (qty * price).toFixed(2);
                calculateGrandTotal();
            }

            function calculateGrandTotal() {
                var subtotal = 0;
                document.querySelectorAll('#orderDetailsTable tbody .row-total').forEach(function (el) {
                    subtotal += parseFloat(el.value) || 0;
                });

                var shipping = parseFloat(document.getElementById('shippingCost').value)   || 0;
                var discount = parseFloat(document.getElementById('couponDiscount').value) || 0;
                var grand    = subtotal + shipping - discount;

                document.getElementById('subtotalDisplay').innerText   = '৳' + subtotal.toFixed(2);
                document.getElementById('grandTotalDisplay').innerText = '৳' + grand.toFixed(2);
            }

            function bindRow(row) {
                // Bind quantity input
                row.querySelector('.quantity-input').addEventListener('input', function () {
                    calculateRowTotal(row);
                });

                // Bind unit price input only (first .price-input)
                row.querySelector('.price-input').addEventListener('input', function () {
                    calculateRowTotal(row);
                });

                // Bind remove button
                row.querySelector('.remove-row').addEventListener('click', function () {
                    if (confirm('Remove this product?')) {
                        row.remove();
                        updateRowNumbers();
                        calculateGrandTotal();
                    }
                });

                // Calculate immediately on bind
                calculateRowTotal(row);
            }

            function updateRowNumbers() {
                document.querySelectorAll('#orderDetailsTable tbody tr').forEach(function (row, i) {
                    row.children[0].innerText = i + 1;
                });
            }

            // ---- Bind all existing rows on page load ----
            document.querySelectorAll('#orderDetailsTable tbody tr').forEach(function (row) {
                bindRow(row);
            });

            // ---- Shipping & discount change ----
            document.getElementById('shippingCost').addEventListener('input',   calculateGrandTotal);
            document.getElementById('couponDiscount').addEventListener('input', calculateGrandTotal);

            // ---- Initial calculation ----
            calculateGrandTotal();

            // ---- Add product button ----
            document.getElementById('addProductBtn').addEventListener('click', function () {
                var select    = document.getElementById('addProductSelect');
                var productId = select.value;
                var selected  = select.options[select.selectedIndex];

                if (!productId) {
                    alert('Please select a product first.');
                    return;
                }

                var productName = selected.dataset.name || selected.text;
                var qty         = parseFloat(document.getElementById('addQty').value)       || 1;
                var price       = parseFloat(document.getElementById('addPrice').value)     || 0;
                var wholesale   = parseFloat(document.getElementById('addWholesale').value) || 0;

                var tbody    = document.querySelector('#orderDetailsTable tbody');
                var rowIndex = tbody.rows.length + 1;

                var tr = document.createElement('tr');
                tr.innerHTML =
                    '<td>' + rowIndex + '</td>' +
                    '<td>' +
                    productName +
                    '<input type="hidden" name="order_detail_ids[]" value="">' +
                    '<input type="hidden" name="product_ids[]" value="' + productId + '">' +
                    '</td>' +
                    '<td>' +
                    '<input type="number" name="quantities[]" class="form-control form-control-sm quantity-input" value="' + qty + '" min="1">' +
                    '</td>' +
                    '<td>' +
                    '<input type="number" name="prices[]" class="form-control form-control-sm  " readonly value="' + price + '" step="0.01">' +
                    '</td>' +
                    '<td>' +
                    '<input type="number" name="whole_sale_prices[]" class="form-control form-control-sm price-input" value="' + wholesale + '" step="0.01">' +
                    '</td>' +
                    '<td>' +
                    '<input type="text" class="form-control form-control-sm row-total" readonly>' +
                    '</td>' +
                    '<td>' +
                    '<button type="button" class="btn btn-sm btn-danger remove-row">×</button>' +
                    '</td>';

                // Append to BOTTOM of table
                tbody.appendChild(tr);

                // Bind events & calculate total immediately
                bindRow(tr);

                // Fix all row numbers
                updateRowNumbers();

                // Reset add-product fields
                $('#addProductSelect').val(null).trigger('change');
                document.getElementById('addQty').value       = 1;
                document.getElementById('addPrice').value     = 0;
                document.getElementById('addWholesale').value = 0;
            });

        }); // end waitForJQueryAndSelect2
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\XAMPP\htdocs\zhennatural\resources\views/backend/whole_sales/edit_order.blade.php ENDPATH**/ ?>