@extends('backend.layouts.app')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0">Edit Order #{{ $order->code }}</h4>
                    </div>

                    <div class="card-body">
                        <form action="{{ route('orders.update', $order->id) }}" method="POST">
                            @csrf
                            @method('PUT')

                            <!-- ================= ORDER & SHIPPING INFO ================= -->
                            <div class="row">
                                <div class="col-md-6">
                                    <h5>Order Information</h5>

                                    <div class="mb-2">
                                        <label>Order Code</label>
                                        <input type="text" class="form-control" value="{{ $order->code }}" disabled>
                                    </div>

                                    <div class="mb-2">
                                        <label>Delivery Status</label>
                                        <select name="delivery_status" class="form-control">
                                            @foreach(['pending','confirmed','on_delivery','delivered','cancelled'] as $status)
                                                <option value="{{ $status }}" {{ $order->delivery_status==$status?'selected':'' }}>
                                                    {{ ucfirst(str_replace('_',' ',$status)) }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="mb-2">
                                        <label>Payment Status</label>
                                        <select name="payment_status" class="form-control">
                                            <option value="unpaid" {{ $order->payment_status=='unpaid'?'selected':'' }}>Unpaid</option>
                                            <option value="paid" {{ $order->payment_status=='paid'?'selected':'' }}>Paid</option>
                                        </select>
                                    </div>
                                </div>

                                @php $shipping = json_decode($order->shipping_address,true); @endphp
                                <div class="col-md-6">
                                    <h5>Shipping Information</h5>

                                    <div class="mb-2">
                                        <label>Name</label>
                                        <input type="text" name="shipping_name" class="form-control" value="{{ $shipping['name'] ?? '' }}">
                                    </div>

                                    <div class="mb-2">
                                        <label>Phone</label>
                                        <input type="text" name="shipping_phone" class="form-control" value="{{ $shipping['phone'] ?? '' }}">
                                    </div>

                                    <div class="mb-2">
                                        <label>Address</label>
                                        <textarea name="shipping_address" class="form-control">{{ $shipping['address'] ?? '' }}</textarea>
                                    </div>
                                </div>
                            </div>

                            <!-- ================= ORDER DETAILS ================= -->
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h5>Order Details</h5>

                                    <div class="table-responsive">
                                        <table class="table table-bordered" id="orderDetailsTable">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Product</th>
                                                <th width="90">Qty</th>
                                                <th width="120">Price</th>
                                                <th width="120">Total</th>
                                                <th width="70">Action</th>
                                            </tr>
                                            </thead>

                                            <tbody>
                                            @foreach($order->orderDetails as $key => $detail)
                                                <tr>
                                                    <td>{{ $key+1 }}</td>

                                                    <td>
                                                        {{ $detail->product->name ?? 'Product' }}
                                                        <input type="hidden" name="order_detail_ids[]" value="{{ $detail->id }}">
                                                        <input type="hidden" name="product_ids[]" value="{{ $detail->product_id }}">
                                                    </td>

                                                    <td>
                                                        <input type="number"
                                                               name="quantities[]"
                                                               class="form-control form-control-sm quantity-input"
                                                               value="{{ $detail->quantity }}" min="1">
                                                    </td>

                                                    <td>
                                                        <input type="number"
                                                               name="prices[]"
                                                               class="form-control form-control-sm price-input"
                                                               value="{{ $detail->price }}"
                                                               step="0.01">
                                                    </td>

                                                    <td>
                                                        <input type="text"
                                                               class="form-control form-control-sm row-total"
                                                               readonly>
                                                    </td>

                                                    <td>
                                                        <button type="button" class="btn btn-sm btn-danger remove-row">×</button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>

                                            <tfoot>
                                            <tr>
                                                <th colspan="4" class="text-end">Subtotal</th>
                                                <th colspan="2" id="subtotalDisplay">৳0.00</th>
                                            </tr>

                                            <tr>
                                                <th colspan="4" class="text-end">Shipping Charge</th>
                                                <th colspan="2">
                                                    <input type="number"
                                                           name="shipping_cost"
                                                           id="shippingCost"
                                                           class="form-control form-control-sm"
                                                           value="{{ $order->shipping_cost }}"
                                                           step="0.01">
                                                </th>
                                            </tr>

                                            <tr>
                                                <th colspan="4" class="text-end">Coupon Discount</th>
                                                <th colspan="2">
                                                    <input type="number"
                                                           name="coupon_discount"
                                                           id="couponDiscount"
                                                           class="form-control form-control-sm"
                                                           value="{{ $order->coupon_discount }}"
                                                           step="0.01">
                                                </th>
                                            </tr>

                                            <tr>
                                                <th colspan="4" class="text-end">Grand Total</th>
                                                <th colspan="2" id="grandTotalDisplay">৳0.00</th>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <div class="mt-3">
                                <a href="{{ route('orders.index') }}" class="btn btn-secondary">Cancel</a>
                                <button type="submit" class="btn btn-primary">Update Order</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ================= FULL JAVASCRIPT ================= -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {

            function calculateRowTotal(row) {
                const qty   = parseFloat(row.querySelector('.quantity-input').value) || 0;
                const price = parseFloat(row.querySelector('.price-input').value) || 0;

                row.querySelector('.row-total').value = (qty * price).toFixed(2);
                calculateGrandTotal();
            }

            function calculateGrandTotal() {
                let subtotal = 0;
                document.querySelectorAll('.row-total').forEach(el => {
                    subtotal += parseFloat(el.value) || 0;
                });

                const shipping = parseFloat(document.getElementById('shippingCost').value) || 0;
                const discount = parseFloat(document.getElementById('couponDiscount').value) || 0;

                const grand = subtotal + shipping - discount;

                document.getElementById('subtotalDisplay').innerText   = '৳' + subtotal.toFixed(2);
                document.getElementById('grandTotalDisplay').innerText = '৳' + grand.toFixed(2);
            }

            function bindRow(row) {
                row.querySelector('.quantity-input').addEventListener('input', () => calculateRowTotal(row));
                row.querySelector('.price-input').addEventListener('input', () => calculateRowTotal(row));

                row.querySelector('.remove-row').addEventListener('click', () => {
                    if (confirm('Remove product?')) {
                        row.remove();
                        updateRowNumbers();
                        calculateGrandTotal();
                    }
                });

                calculateRowTotal(row);
            }

            function updateRowNumbers() {
                document.querySelectorAll('#orderDetailsTable tbody tr').forEach((row, i) => {
                    row.children[0].innerText = i + 1;
                });
            }

            document.querySelectorAll('#orderDetailsTable tbody tr').forEach(bindRow);

            document.getElementById('shippingCost').addEventListener('input', calculateGrandTotal);
            document.getElementById('couponDiscount').addEventListener('input', calculateGrandTotal);

            calculateGrandTotal();
        });
    </script>
@endsection
