<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{  translate('INVOICE') }}</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta charset="UTF-8">
	<style media="all">
        @page {
			margin: 0;
			padding:0;
		}
		body{
			font-size: 1rem;
            font-family: '<?php echo  $font_family ?>';
            font-weight: normal;
            direction: <?php echo  $direction ?>;
            text-align: <?php echo  $text_align ?>;
			padding:0;
			margin:0;
		}
		.gry-color *,
		.gry-color{
			color:#000;
		}
		table{
			width: 100%;
		}
		table th{
			font-weight: normal;
		}
		table.padding th{
            padding: .5rem .7rem;
		}
		table.padding td{
            padding: .5rem .7rem;
		}
		table.sm-padding td{
            padding: .3rem .7rem;
		}
		.border-bottom td,
		.border-bottom th{
			border-bottom:1px solid #eceff4;
		}
		.text-left{
			text-align:<?php echo  $text_align ?>;
		}
		.text-right{
			text-align:<?php echo  $not_text_align ?>;
		}
		
		@media print {
    * {
        -webkit-print-color-adjust: exact !important;
        print-color-adjust: exact !important;
    }

  
    
    .border-bottom-last {
        border-bottom:  2px dotted red !important; /* thicker for print visibility */
    }
}

	</style>
</head>
<body>
	<div>

		@php
			$logo = get_setting('header_logo');
		@endphp

		<div style="background: #eceff4;padding: 1rem;">
			<table>
				<tr>
					<td>
						@if($logo != null)
							<img src="{{ uploaded_asset($logo) }}" height="40" style="display:inline-block;">
						@else
							<img src="{{ static_asset('assets/img/logo.png') }}" height="40" style="display:inline-block;">
						@endif
					</td>
					<td style="font-size: 1.8rem;" class="text-right strong">{{  translate('INVOICE') }}</td>
				</tr>
			</table>
			<table>
				<tr>
					<td style="font-size: 1.2rem;" class="strong">{{ get_setting('site_name') }}</td>
					<td class="text-right"></td>
				</tr>
				<tr>
					<td class="gry-color small" style="font-size: 1rem;">427, Tejgaon I/A, Dhaka-1208, Bangladesh</td>
					<td class="text-right"></td>
				</tr>
				<tr>
					<td class="gry-color small" style="font-size: 1rem;">Hotline/Whatsapp:01844545500</td>
					<td class="text-right small" style="font-size: 1rem;"><span class="gry-color small">{{  translate('Order ID') }}:</span> <span class="strong">{{ $order->code }}</span></td>
				</tr>
				<tr>
					<td class="gry-color small" style="font-size: 1rem;"></td>
					<td class="text-right small"><span class="gry-color small" style="font-size: 1rem;">{{  translate('Order Date') }}:</span> <span class=" strong">{{ date('d-m-Y', $order->date) }}</span></td>
				</tr>
				<tr>
					<td class="gry-color small" style="font-size: 1rem;"></td>
					<td class="text-right small" style="font-size: 1rem;">
                        <span class="gry-color small">
                            {{  translate('Payment method') }}:
                        </span>
                        <span class="strong">
                            {{ translate(ucfirst(str_replace('_', ' ', $order->payment_type))) }}
                        </span>
                    </td>
				</tr>
			</table>

		</div>

		<div style="padding: 1.5rem;padding-bottom: 0">
            <table>
				@php
					$shipping_address = json_decode($order->shipping_address);
				@endphp
				<tr><td class="strong small gry-color" style="font-size: 1.1rem;">{{ translate('Bill to') }}:</td></tr>
				<tr><td class="strong" style="font-size: 1.1rem;">{{ $shipping_address->name }}</td></tr>
				<tr><td class="gry-color small" style="font-size: 1rem;">{{ $shipping_address->address }}, {{ $shipping_address->city }},  @if(isset(json_decode($order->shipping_address)->state)) {{ json_decode($order->shipping_address)->state }} - @endif {{ $shipping_address->postal_code }}, {{ $shipping_address->country }}</td></tr>
				<tr><td class="gry-color small" style="font-size: 1rem;">{{ translate('Email') }}: {{ $shipping_address->email }}</td></tr>
				<tr><td class="gry-color small" style="font-size: 1rem;">{{ translate('Phone') }}: {{ $shipping_address->phone }}</td></tr>
			</table>
		</div>

	    <div style="padding: 1.5rem;">
			<table class="padding text-left small border-bottom" style="font-size: 1rem;">
				<thead>
	                <tr class="gry-color" style="background: #eceff4;font-size: 1.05rem;">
	                    <th width="10%" class="text-left">{{ translate('Photo') }}</th>
	                    <th width="25%" class="text-left">{{ translate('Product Name') }}</th>
						<th width="15%" class="text-left">{{ translate('Delivery Type') }}</th>
	                    <th width="10%" class="text-left">{{ translate('Qty') }}</th>
	                    <th width="15%" class="text-left">{{ translate('Unit Price') }}</th>
	                    <th width="10%" class="text-left">{{ translate('Tax') }}</th>
	                    <th width="15%" class="text-right">{{ translate('Total') }}</th>
	                </tr>
				</thead>
				<tbody class="strong">
	                @foreach ($order->orderDetails as $key => $orderDetail)
		                @if ($orderDetail->product != null)
							<tr class="" style="font-size: 1rem;">
                                <td>
                                    @if ($orderDetail->product != null && $orderDetail->product->auction_product == 0)
                                        <a href="{{ route('product', $orderDetail->product->slug) }}" target="_blank">
                                            <img height="60" src="{{ uploaded_asset($orderDetail->product->thumbnail_img) }}">
                                        </a>
                                    @elseif ($orderDetail->product != null && $orderDetail->product->auction_product == 1)
                                        <a href="{{ route('auction-product', $orderDetail->product->slug) }}" target="_blank">
                                            <img height="60" src="{{ uploaded_asset($orderDetail->product->thumbnail_img) }}">
                                        </a>
                                    @else
                                        <strong>{{ translate('N/A') }}</strong>
                                    @endif
                                </td>
								<td style="font-size: 1.05rem;">
                                    {{ $orderDetail->product->name }}
                                    @if($orderDetail->variation != null) ({{ $orderDetail->variation }}) @endif
                                    <br>
                                    <small style="font-size: 0.95rem;">
                                        @php
                                            $product_stock = json_decode($orderDetail->product->stocks->first(), true);
                                        @endphp
                                        {{translate('SKU')}}: {{ $product_stock['sku'] }}
                                    </small>
                                </td>
								<td>
									@if ($order->shipping_type != null && $order->shipping_type == 'home_delivery')
										{{ translate('Home Delivery') }}
									@elseif ($order->shipping_type == 'pickup_point')
										@if ($order->pickup_point != null)
											{{ $order->pickup_point->getTranslation('name') }} ({{ translate('Pickip Point') }})
										@else
                                            {{ translate('Pickup Point') }}
										@endif
									@elseif ($order->shipping_type == 'carrier')
										@if ($order->carrier != null)
											{{ $order->carrier->name }} ({{ translate('Carrier') }})
											<br>
											{{ translate('Transit Time').' - '.$order->carrier->transit_time }}
										@else
											{{ translate('Carrier') }}
										@endif
									@endif
								</td>
								<td class="">{{ $orderDetail->quantity }}</td>
								<td class="currency">{{ single_price($orderDetail->price/$orderDetail->quantity) }}</td>
								<td class="currency">{{ single_price($orderDetail->tax/$orderDetail->quantity) }}</td>
			                    <td class="text-right currency">{{ single_price($orderDetail->price+$orderDetail->tax) }}</td>
							</tr>
		                @endif
					@endforeach
	            </tbody>
			</table>
		</div>

	    <div style="padding:0 1.8rem;">
	        <table class="text-right sm-padding strong" style="font-size: 1.05rem;">
	        	<thead>
	        		<tr>
	        			<th width="60%"></th>
	        			<th width="40%"></th>
	        		</tr>
	        	</thead>
		        <tbody>
			        <tr>
			            <td class="text-left">
                            @php
                                $removedXML = '<?xml version="1.0" encoding="UTF-8"?>';
                            @endphp
                            @php
                                $invoiceUrl = route('invoice.print', $order->id);
                            @endphp

                            {!! str_replace($removedXML, '', QrCode::size(100)->generate($invoiceUrl)) !!}

                        </td>
                        
			            <td>
					        <table class="text-right sm-padding strong border-bottom-last" style="font-size: 1.05rem; border-collapse: collapse; width:100%;">
						        <tbody >
							        <tr>
							            <th class="gry-color text-left">{{ translate('Sub Total') }}</th>
							            <td class="currency">{{ single_price($order->orderDetails->sum('price')) }}</td>
							        </tr>
							        <tr>
							            <th class="gry-color text-left">{{ translate('Shipping Cost') }}</th>
							            <td class="currency">{{ single_price($order->shipping_cost) }}</td>
							        </tr>
{{--							        <tr class="border-bottom">--}}
{{--							            <th class="gry-color text-left">{{ translate('Total Tax') }}</th>--}}
{{--							            <td class="currency">{{ single_price($order->orderDetails->sum('tax')) }}</td>--}}
{{--							        </tr>--}}
				                    <tr class="border-bottom">
							            <th class="gry-color text-left">{{ translate('Coupon Discount') }}</th>
							            <td class="currency">{{ single_price($order->coupon_discount) }}</td>
							        </tr>
							        <tr style="font-size: 1.05rem; border-bottom:1px solid red" class="border-bottom-last">
							            <th class="text-left strong" style="font-size: 1.15rem;">{{ translate('Grand Total') }}</th>
							            <td class="currency" style="font-size: 1.15rem;">{{ single_price($order->grand_total) }}</td>
							        </tr>
						        </tbody>
						    </table>
			            </td>
			        </tr>
		        </tbody>
		    </table>
		    <table class="text-right sm-padding strong" style="font-size: 1.05rem;">
	        	<thead>
	        		<tr>
	        			<th width="60%"></th>
	        			<th width="40%"></th>
	        		</tr>
	        	</thead>
		        <tbody>
			        <tr>
			            <td class="text-left" style="color:red">
                         <a>  Terms & Conditions</a>
                           <br>
                           Bkash- Marchants: 01950099896

                        </td>
                        
			            <td>
					        <table class="text-right sm-padding strong " style="font-size: 1.05rem; border-collapse: collapse; width:100%;">
						        <tbody >
							       
						        </tbody>
						    </table>
			            </td>
			        </tr>
		        </tbody>
		    </table>
	    </div>
	    
	 <div style="text-align: center; color: red; top:10px">
    <span>This is a computer generated invoice; there is no need for any signature</span>
</div>


	</div>
</body>
</html>
