<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\PreventDemoModeChanges;

class CombinedOrder extends Model
{
    use PreventDemoModeChanges;
    protected $fillable = [
        'user_id',
        'shipping_address',
        'grand_total',
        // add other fields like 'status', 'payment_method' if needed
    ];
    public function orders(){
    	return $this->hasMany(Order::class);
    }

    public function user(){
    	return $this->belongsTo(User::class);
    }
}
