<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Order;
use Illuminate\Support\Facades\Http;

class OrderCourierController extends Controller
{
  public function check(Order $order)
{
    if (empty($order->shipping_address)) {
        return response()->json([
            'success' => false,
            'message' => 'Shipping address missing'
        ]);
    }

    // Decode JSON string
    $shipping = json_decode($order->shipping_address, true);

    if (!is_array($shipping) || empty($shipping['phone'])) {
        return response()->json([
            'success' => false,
            'message' => 'Phone number not found in shipping address'
        ]);
    }

    $phone = $shipping['phone'];

    $response = Http::withHeaders([
        'Authorization' => 'Bearer ' . config('services.bdcourier.api_key'),
        'Content-Type'  => 'application/json',
    ])->post(
        config('services.bdcourier.base_url') . '/courier-check',
        ['phone' => $phone]
    );

    if ($response->failed()) {
        return response()->json([
            'success' => false,
            'message' => 'BDCourier API error',
            'error'   => $response->json(),
        ]);
    }

    return response()->json([
        'success' => true,
        'data'    => $response->json('data'),
    ]);
}

}
