<?php

/** @noinspection PhpUndefinedClassInspection */

namespace App\Http\Controllers\Api\V2;

use App\Http\Controllers\OTPVerificationController;
use App\Mail\GuestAccountOpeningMailManager;
use App\Models\Address;
use App\Models\BusinessSetting;
use Illuminate\Http\Request;
use App\Models\User;
use App\Notifications\AppEmailVerificationNotification;
use Hash;
use Socialite;
use App\Models\Cart;
use App\Rules\Recaptcha;
use App\Utility\EmailUtility;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Laravel\Sanctum\PersonalAccessToken;
use App\Mail\ContactMailManager;
use App\Models\Contact;
use Mail;

class AuthController extends Controller
{

    private function sms_send($number, $message)
    {
        $url = "http://bulksmsbd.net/api/smsapi";

        $data = [
            "api_key" => "tto9lg9fbL5HV6yRz88A",
            "senderid" => "8809648905551",
            "number" => $number,
            "message" => $message
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data); // Don't use http_build_query
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $response = curl_exec($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);

        if ($curl_error) {
            \Log::error('SMS Send CURL Error: ' . $curl_error);
            return false;
        }

        \Log::info('SMS API Response: ' . $response);

        // Check if response indicates success
        // Adjust this based on what the API returns for success
        return $response;
    }

// Fixed signup method (SMS section only)
    public function signup(Request $request)
    {
        // Custom validation messages
        $messages = [
            'name.required' => translate('Name is required'),
            'phone.required' => translate('Phone is required'),
            'phone.numeric' => translate('Phone must be numeric'),
            'phone.digits_between' => translate('Phone must be between 10 and 14 digits'),
            'phone.unique' => translate('Phone number is already registered'),
            'password.required' => translate('Password is required'),
            'password.min' => translate('Password must be at least 6 characters'),
            'password.confirmed' => translate('Password confirmation does not match'),
        ];

        // Validation rules
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'phone' => 'required|numeric|digits_between:10,14|unique:users,phone',
            'password' => 'required|min:6|confirmed',
        ], $messages);

        // If validation fails
        if ($validator->fails()) {
            return response()->json([
                'result' => false,
                'message' => $validator->errors()->all()
            ]);
        }

         $phone = $request->phone;
        if (!str_starts_with($phone, '880')) {
            if (str_starts_with($phone, '0')) {
                $phone = '880' . substr($phone, 1);
            } elseif (str_starts_with($phone, '+880')) {
                $phone = substr($phone, 1);
            } else {
                $phone = '880' . $phone;
            }
        }

        // Create new user
        $user = new User();
        $user->name = $request->name;
        $user->phone = $phone;
        $user->password = bcrypt($request->password);
        $user->verification_code = rand(100000, 999999);
        $user->save();

        // Normalize phone to 880 prefix
        $phone = $user->phone;
        if (!str_starts_with($phone, '880')) {
            if (str_starts_with($phone, '0')) {
                $phone = '880' . substr($phone, 1);
            } elseif (str_starts_with($phone, '+880')) {
                $phone = substr($phone, 1);
            } else {
                $phone = '880' . $phone;
            }
        }

        // Send SMS
        $message = "Your verification code is: " . $user->verification_code;
        $response = $this->sms_send($phone, $message);

        // Rollback if SMS fails
        if (!$response) {
            $user->delete();
            return response()->json([
                'result' => false,
                'message' => 'SMS sending failed, please try again'
            ]);
        }

        // Generate API token
        $token = $user->createToken('tokens')->plainTextToken;

        // Optional: handle temp user ID
        $tempUserId = $request->has('temp_user_id') ? $request->temp_user_id : null;

        // Return successful login response with token
        return $this->loginSuccess($user, $token, $tempUserId);
    }
    
     public function updatePassword(Request $request)
    {
        $messages = [
        
            'phone.required' => translate('Phone is required'),
            'phone.numeric' => translate('Phone must be numeric'),
            'phone.digits_between' => translate('Phone must be between 10 and 14 digits'),
            'phone.unique' => translate('Phone number is already registered'),
            'password.required' => translate('Password is required'),
            'password.min' => translate('Password must be at least 6 characters'),
            'password.confirmed' => translate('Password confirmation does not match'),
        ];

        // Validation rules
        $validator = Validator::make($request->all(), [
        
            'phone' => 'required|numeric|digits_between:10,14|unique:users,phone',
            'password' => 'required|min:6|confirmed',
        ], $messages);

        // If validation fails
        if ($validator->fails()) {
            return response()->json([
                'result' => false,
                'message' => $validator->errors()->all()
            ]);
        }

        $phone = $request->phone;
        if (!str_starts_with($phone, '880')) {
            if (str_starts_with($phone, '0')) {
                $phone = '880' . substr($phone, 1);
            } elseif (str_starts_with($phone, '+880')) {
                $phone = substr($phone, 1);
            } else {
                $phone = '880' . $phone;
            }
        }

        // Create new user
        $user = User::where('phone', $phone)->first();
        if(!$user){
            return response()->json([
                'result' => false,
                'message' => 'Phone number not found'
            ]);
        }

        $user->password = bcrypt($request->password);
        $user->save();
         return response()->json([
             'result' => true,
             'message' => 'Password updated successfully'
         ]);

    }

//     public function checkoutPhoneVerify(Request $request)
//     {
//         // Custom validation messages
//         $messages = [
//             'phone.required' => translate('Phone is required'),
//             'phone.numeric' => translate('Phone must be numeric'),
//             'phone.digits_between' => translate('Phone must be between 10 and 14 digits'),
//         ];

//         // Basic validation
//         $validator = Validator::make($request->all(), [
//             'phone' => 'required|numeric|digits_between:10,14',
//         ], $messages);

//         if ($validator->fails()) {
//             return response()->json([
//                 'result' => false,
//                 'message' => $validator->errors()->all()
//             ]);
//         }

//         // Normalize phone to 880 prefix
//         $phone = $request->phone;
//         if (!str_starts_with($phone, '880')) {
//             if (str_starts_with($phone, '0')) {
//                 $phone = '880' . substr($phone, 1);
//             } elseif (str_starts_with($phone, '+880')) {
//                 $phone = substr($phone, 1);
//             } else {
//                 $phone = '880' . $phone;
//             }
//         }

//         // Check if user already exists
//         $user = User::where('phone', $request->phone)->first();

//         if ($user) {
//             // User exists → just generate a new verification code
//             $user->verification_code = rand(100000, 999999);
//             $user->save();
//         } else {
//             // User doesn't exist → create new user
//             $user = new User();
//             $user->phone = $request->phone;
//             $user->verification_code = rand(100000, 999999);
//             $user->save();
//         }

//         // Send SMS
//         $message = "Your verification code is: " . $user->verification_code;
//         $smsSent = $this->sms_send($phone, $message);

//         // Generate API token
// //        $token = $user->createToken('tokens')->plainTextToken;

//         if ($smsSent) {
//             return $this->loginSuccess($user, $request->temp_user_id ?? null);
//         } else {
//             return response()->json([
//                 'result' => true,
//                 'message' => 'Verification code could not be sent via SMS, but user is ready.',
//                 'user' => $user,

//             ]);
//         }
//     }

public function checkoutPhoneVerify(Request $request)
{
    $validator = Validator::make($request->all(), [
        'phone' => 'required|numeric|digits_between:10,14',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'result' => false,
            'message' => $validator->errors()->all(),
        ]);
    }

    // Normalize phone
    $phone = $request->phone;
    if (str_starts_with($phone, '+880')) {
        $phone = substr($phone, 1);
    } elseif (str_starts_with($phone, '0')) {
        $phone = '880' . substr($phone, 1);
    } elseif (!str_starts_with($phone, '880')) {
        $phone = '880' . $phone;
    }

    // Find or create user
    $user = User::firstOrCreate(
        ['phone' => $phone],
        ['verification_code' => rand(100000, 999999)]
    );

    $user->verification_code = rand(100000, 999999);
    $user->save();

    // Send OTP
    $this->sms_send($phone, "Your verification code is {$user->verification_code}");

    // return $this->loginSuccess(
    //     $user,
    //     $request->temp_user_id ?? []
    // );
}


       public function resendCode(Request $request)
    {

        $phone = $request->phone;
        if (!str_starts_with($phone, '880')) {
            if (str_starts_with($phone, '0')) {
                $phone = '880' . substr($phone, 1);
            } elseif (str_starts_with($phone, '+880')) {
                $phone = substr($phone, 1);
            } else {
                $phone = '880' . $phone;
            }
        }
        $user = User::where('phone', $request->phone)->first();

        if ($user) {
            // User exists → just generate a new verification code
            $user->verification_code = rand(100000, 999999);
            $user->save();
        } else {
            // User doesn't exist → create new user
            $user = new User();
            $user->phone = $request->phone;
            $user->verification_code = rand(100000, 999999);
            $user->save();
        }

        // Send SMS
        $message = "Your verification code is: " . $user->verification_code;
        $smsSent = $this->sms_send($phone, $message);

//        if ($user->email) {
//            try {
//                $user->notify(new AppEmailVerificationNotification());
//            } catch (\Exception $e) {
//            }
//        } else {
//            $otpController = new OTPVerificationController();
//            $otpController->send_code($user);
//        }

        $user->save();

        return response()->json([
            'result' => true,
            'message' => translate('Verification code is sent again'),
        ], 200);
    }

    public function confirmCode(Request $request)
    {
        $user = User::where('verification_code', $request->verification_code)->first();

        if ($user->verification_code == $request->verification_code) {
            $user->email_verified_at = date('Y-m-d H:i:s');
            $user->verification_code = null;
            $user->save();
            return response()->json([
                'result' => true,
                'message' => translate('Your account is now verified'),
            ], 200);
        } else {
            return response()->json([
                'result' => false,
                'message' => translate('Code does not match, you can request for resending the code'),
            ], 200);
        }
    }

    public function login(Request $request)
    {
        // Validation
        $validator = Validator::make($request->all(), [
            'phone' => 'required|numeric',
            'password' => 'required',
        ], [
            'phone.required' => translate('Phone is required'),
            'phone.numeric' => translate('Phone must be a number.'),
            'password.required' => translate('Password is required'),
        ]);

        if ($validator->fails()) {
            return response()->json([
                'result' => false,
                'message' => $validator->errors()->all()
            ]);
        }

        
        $phone = $request->phone;
        if (!str_starts_with($phone, '880')) {
            if (str_starts_with($phone, '0')) {
                $phone = '880' . substr($phone, 1);
            } elseif (str_starts_with($phone, '+880')) {
                $phone = substr($phone, 1);
            } else {
                $phone = '880' . $phone;
            }
        }
        $password = $request->password;

        // Get user (only customer for now, adjust user_type if needed)
        $user = User::where('phone', $phone)->first();

        if (!$user) {
            return response()->json([
                'result' => false,
                'message' => translate('User not found'),
                'user' => null
            ], 401);
        }

        if ($user->banned) {
            return response()->json([
                'result' => false,
                'message' => translate('User is banned'),
                'user' => null
            ], 401);
        }

        if (!Hash::check($password, $user->password)) {
            return response()->json([
                'result' => false,
                'message' => translate('Unauthorized'),
                'user' => null
            ], 401);
        }

        $tempUserId = $request->has('temp_user_id') ? $request->temp_user_id : null;
        return $this->loginSuccess($user, '', $tempUserId);
    }


    public function user(Request $request)
    {
        return response()->json($request->user());
    }

    public function logout(Request $request)
    {

        $user = request()->user();
        $user->tokens()->where('id', $user->currentAccessToken()->id)->delete();

        return response()->json([
            'result' => true,
            'message' => translate('Successfully logged out')
        ]);
    }

    public function socialLogin(Request $request)
    {
        if (!$request->provider) {
            return response()->json([
                'result' => false,
                'message' => translate('User not found'),
                'user' => null
            ]);
        }

        switch ($request->social_provider) {
            case 'facebook':
                $social_user = Socialite::driver('facebook')->fields([
                    'name',
                    'first_name',
                    'last_name',
                    'email'
                ]);
                break;
            case 'google':
                $social_user = Socialite::driver('google')
                    ->scopes(['profile', 'email']);
                break;
            case 'twitter':
                $social_user = Socialite::driver('twitter');
                break;
            case 'apple':
                $social_user = Socialite::driver('sign-in-with-apple')
                    ->scopes(['name', 'email']);
                break;
            default:
                $social_user = null;
        }
        if ($social_user == null) {
            return response()->json(['result' => false, 'message' => translate('No social provider matches'), 'user' => null]);
        }

        if ($request->social_provider == 'twitter') {
            $social_user_details = $social_user->userFromTokenAndSecret($request->access_token, $request->secret_token);
        } else {
            $social_user_details = $social_user->userFromToken($request->access_token);
        }

        if ($social_user_details == null) {
            return response()->json(['result' => false, 'message' => translate('No social account matches'), 'user' => null]);
        }

        $existingUserByProviderId = User::where('provider_id', $request->provider)->first();

        if ($existingUserByProviderId) {
            $existingUserByProviderId->access_token = $social_user_details->token;
            if ($request->social_provider == 'apple') {
                $existingUserByProviderId->refresh_token = $social_user_details->refreshToken;
                if (!isset($social_user->user['is_private_email'])) {
                    $existingUserByProviderId->email = $social_user_details->email;
                }
            }
            $existingUserByProviderId->save();
            return $this->loginSuccess($existingUserByProviderId);
        } else {
            $existing_or_new_user = User::firstOrNew(
                [['email', '!=', null], 'email' => $social_user_details->email]
            );

            // $existing_or_new_user->user_type = 'customer';
            $existing_or_new_user->provider_id = $social_user_details->id;

            if (!$existing_or_new_user->exists) {
                if ($request->social_provider == 'apple') {
                    if ($request->name) {
                        $existing_or_new_user->name = $request->name;
                    } else {
                        $existing_or_new_user->name = 'Apple User';
                    }
                } else {
                    $existing_or_new_user->name = $social_user_details->name;
                }
                $existing_or_new_user->email = $social_user_details->email;
                $existing_or_new_user->email_verified_at = date('Y-m-d H:m:s');
            }

            $existing_or_new_user->save();

            return $this->loginSuccess($existing_or_new_user);
        }
    }

    // Guest user Account Create
    public function guestUserAccountCreate(Request $request)
    {
        $success = 1;
        $password = substr(hash('sha512', rand()), 0, 8);
        $isEmailVerificationEnabled = get_setting('email_verification');

        // User Create
        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->phone = addon_is_activated('otp_system') ? $request->phone : null;
        $user->password = Hash::make($password);
        $user->email_verified_at = $isEmailVerificationEnabled != 1 ? date('Y-m-d H:m:s') : null;
        $user->save();

        // Account Opening and verification(if activated) eamil send
        try {
            EmailUtility::customer_registration_email('registration_from_system_email_to_customer', $user, $password);
        } catch (\Exception $e) {
            $success = 0;
            $user->delete();
        }

        if($success == 0){
            return response()->json([
                'result' => false,
                'message' => translate('Something went wrong!')
            ]);
        }

        if($isEmailVerificationEnabled == 1){
            $user->notify(new AppEmailVerificationNotification());
        }

        // User Address Create
        $address = new Address();
        $address->user_id       = $user->id;
        $address->address       = $request->address;
        $address->country_id    = $request->country_id;
        $address->state_id      = $request->state_id;
        $address->city_id       = $request->city_id;
        $address->postal_code   = $request->postal_code;
        $address->phone         = $request->phone;
        $address->longitude     = $request->longitude;
        $address->latitude      = $request->latitude;
        $address->save();

        Cart::where('temp_user_id', $request->temp_user_id)
            ->update([
                'user_id' => $user->id,
                'temp_user_id' => null,
                'address_id' => $address->id
            ]);

        //create token
        $user->createToken('tokens')->plainTextToken;

        return $this->loginSuccess($user);
    }

    // public function loginSuccess($user, $token = null, $tempUserId = null)
    // {

    //     if (!$token) {
    //         $token = $user->createToken('API Token')->plainTextToken;
    //     }

    //     if($tempUserId != null){
    //         Cart::where('temp_user_id', $tempUserId)
    //             ->update([
    //                 'user_id' => $user->id,
    //                 'temp_user_id' => null
    //             ]);
    //     }

    //     return response()->json([
    //         'result' => true,
    //         'message' => translate('Successfully logged in'),
    //         'access_token' => $token,
    //         'token_type' => 'Bearer',
    //         'expires_at' => null,
    //         'user' => [
    //             'id' => $user->id,
    //             'type' => $user->user_type,
    //             'name' => $user->name,
    //             'email' => $user->email,
    //             'avatar' => $user->avatar,
    //             'avatar_original' => uploaded_asset($user->avatar_original),
    //             'phone' => $user->phone,
    //             'email_verified' => $user->email_verified_at != null
    //         ]
    //     ]);
    // }
public function loginSuccess($user, $tempUserIds = [])
{
    $token = $user->createToken('API Token')->plainTextToken;

    /*
    |--------------------------------------------------------------------------
    | Merge Multiple Guest Carts
    |--------------------------------------------------------------------------
    */
    if (!empty($tempUserIds)) {

        // যদি single string আসে, array বানিয়ে নেবে
        $tempUserIds = is_array($tempUserIds)
            ? $tempUserIds
            : [$tempUserIds];

        Cart::whereIn('temp_user_id', $tempUserIds)
            ->update([
                'user_id' => $user->id,
                'temp_user_id' => null,
            ]);
    }

    return response()->json([
        'result' => true,
        'message' => translate('Successfully logged in'),
        'access_token' => $token,
        'token_type' => 'Bearer',
        'user' => [
            'id' => $user->id,
            'phone' => $user->phone,
        ],
    ]);
}


    protected function loginFailed()
    {

        return response()->json([
            'result' => false,
            'message' => translate('Login Failed'),
            'access_token' => '',
            'token_type' => '',
            'expires_at' => null,
            'user' => [
                'id' => 0,
                'type' => '',
                'name' => '',
                'email' => '',
                'avatar' => '',
                'avatar_original' => '',
                'phone' => ''
            ]
        ]);
    }


    public function account_deletion()
    {
        if (auth()->user()) {
            Cart::where('user_id', auth()->user()->id)->delete();
        }
        $auth_user = auth()->user();
        $auth_user->tokens()->where('id', $auth_user->currentAccessToken()->id)->delete();
        $auth_user->customer_products()->delete();

        User::destroy(auth()->user()->id);

        return response()->json([
            "result" => true,
            "message" => translate('Your account deletion successfully done')
        ]);
    }

    public function getUserInfoByAccessToken(Request $request)
    {
        $token = PersonalAccessToken::findToken($request->access_token);
        if (!$token) {
            return $this->loginFailed();
        }
        $user = $token->tokenable;

        if ($user == null) {
            return $this->loginFailed();
        }

        return $this->loginSuccess($user, $request->access_token);
    }
    
     public function contactApi(Request $request)
    {
        // Validation
        $request->validate([
            'name'    => ['required', 'string', 'max:255'],
            'email'   => ['required', 'email'],
            'phone'   => ['nullable', 'string', 'max:20'],
            'content' => ['required', 'string'],

        ]);

        $admin = get_admin();

        // $mailData = [
        //     'name'    => $request->name,
        //     'email'   => $request->email,
        //     'phone'   => $request->phone,
        //     'content' => nl2br($request->content),
        //       'from'    => $request->email,
        //       'subject' => translate('Query Contact'),

        // ];

        try {
            // Send Mail
            // Mail::to($admin->email)->queue(new ContactMailManager($mailData));

            // Save Contact Message
            Contact::create([
                'name'    => $request->name,
                'email'   => $request->email,
                'phone'   => $request->phone,
                'content' => $request->content,
            ]);

            return response()->json([
                'success' => true,
                'message' => translate('Query has been sent successfully'),
            ], 200);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => translate('Something went wrong'),
                'error'   => config('app.debug') ? $e->getMessage() : null,
            ], 500);
        }
    }
}
