<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Http;

class SteadfastCourier
{
    protected $baseUrl;
    protected $apiKey;
    protected $secretKey;

    public function __construct()
    {
        $this->baseUrl   = "https://portal.packzy.com/api/v1";
        $this->apiKey    = config('services.steadfast.api_key');
        $this->secretKey = config('services.steadfast.secret_key');
    }

    /**
     * Place a single order with Steadfast.
     */
    public function createOrder($order)
    {
        $shipping = json_decode($order->shipping_address);

        $payload = [
            'invoice'          => $order->code, // unique invoice/order code
            'recipient_name'   => $shipping->name ?? 'N/A',
            'recipient_phone'  => $shipping->phone ?? '',
            'recipient_address'=> $shipping->address ?? '',
            'cod_amount'       => $order->grand_total,
            'note'             => "Order ID: {$order->id}",
            'item_description' => "E-commerce order from Jersey Factory",
            'delivery_type'    => 0, // 0=home delivery
        ];

        $response = Http::withHeaders([
            'Api-Key'      => $this->apiKey,
            'Secret-Key'   => $this->secretKey,
            'Content-Type' => 'application/json',
        ])->post($this->baseUrl . '/create_order', $payload);

        return $response->json();
    }
}
